/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.planning.mokos.Scheduler;
import cz.insophy.inplan.planning.mokos.Util;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Tuple;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeakFixationScorer
extends Processor {
    private static final Logger log = LoggerFactory.getLogger(WeakFixationScorer.class);
    @VisibleForTesting
    static final String WF_MAP_KEY = "wfMap";

    @Override
    public void setSuccessors(List<Processor> successors) {
        super.setSuccessors(successors);
        this.checkOneSuccessor();
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        super.setScheduler(scheduler);
        this.parseJsonMaps(scheduler.getSuperplan(), scheduler.getOperations());
    }

    private void parseJsonMaps(Superplan superplan, Set<Operation> ops) {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<Map<String, Integer>> wfMapType = new TypeReference<Map<String, Integer>>(){};
        ShopConfiguration conf = superplan.getShopConf();
        PropertyDefinition wfPd = conf.getPropertyDefinition(GeneralizedActionRequest.class, "weakFix");
        if (wfPd == null) {
            log.warn("No weakFix property found for GARs.");
            return;
        }
        for (Operation op : ops) {
            String wf = (String)op.getGar().getProperty(wfPd);
            if (wf == null) continue;
            try {
                Workplace wp;
                Map<String, Integer> wfMap = mapper.readValue(wf, wfMapType);
                String cap = op.getAction().getCapabilityReq();
                IdentityHashMap<Workplace, Integer> res = Maps.newIdentityHashMap();
                for (Map.Entry<String, Integer> entry : wfMap.entrySet()) {
                    wp = conf.getWorkplace(entry.getKey());
                    if (wp == null || !wp.hasCapability(cap)) continue;
                    res.put(wp, (Integer)entry.getValue());
                }
                if (res.isEmpty()) {
                    Map.Entry<String, Integer> entry;
                    Integer fixOrder = wfMap.get("");
                    if (fixOrder == null) continue;
                    entry = conf.getWorkplaces(cap).iterator();
                    while (entry.hasNext()) {
                        wp = (Workplace)entry.next();
                        res.put(wp, fixOrder);
                    }
                } else {
                    for (Workplace wp2 : conf.getWorkplaces(cap)) {
                        if (res.containsKey(wp2)) continue;
                        op.getBounds().updateCompositeBound(this, wp2, Long.MAX_VALUE);
                    }
                }
                op.setProperty(WF_MAP_KEY, res);
            }
            catch (Exception e) {
                log.warn("Cannot parse weakFix property of {}", (Object)op.getGar());
            }
        }
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        for (Operation op : ops) {
            Map wfMap = (Map)op.getProperty(WF_MAP_KEY);
            for (Operation.OperationPlanning planning : op.getPlannings()) {
                Integer score = null;
                if (wfMap != null) {
                    Workplace wp = Util.getFirstPlannedWa(planning).getWorkplace();
                    score = (Integer)wfMap.get(wp);
                }
                if (score == null) {
                    score = Integer.MAX_VALUE;
                }
                planning.setProperty("weak_fix_score", score);
            }
        }
        return Tuple.create(this.getDefaultSuccessor(), ops);
    }
}

